/* 
 * sigwait.c
 *
 * Створює дочірній процес, після чого і батько, і нащадок виводять
 * повідомлення. За допомогою сигналу SIGUSR1 забезпечується першість
 * батька.
 * Ілюструє порядок організації міжзадачної взаємодії за допомогою
 * сигналу SIGUSR1, а також порядок організації пасивного чекання
 * сигналів за допомогою функції sigwait(). Застосувує функції
 * sigprocmask(), kill(), sigwait().
 *
 */

#include <assert.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


int main()
{
        sigset_t set;
        pid_t pid;

        /* Ініціалізує порожній набір сигналів. */
        if (sigemptyset(&set) != 0) {
                perror("sigemptyset()");
                exit(EXIT_FAILURE);
        }
        /* Додає в набір сигнал SIGUSR1. */
        if (sigaddset(&set, SIGUSR1) != 0) {
                perror("sigaddset()");
                exit(EXIT_FAILURE);
        }
        /* Блокує сигнал SIGUSR1. */
        if (sigprocmask(SIG_SETMASK, &set, NULL) != 0) {
                perror("sigprocmask()");
                exit(EXIT_FAILURE);
        }
        /* Створює нащадка. */
        pid = fork();
        if (pid < 0) {
                perror("fork()");
                exit(EXIT_FAILURE);
        }
        if (pid == 0) {
                /* Це код дочірнього процесу */
                int signum;
                int errnum;

                /* Чекає сигнал SIGUSR1. */
                errnum = sigwait(&set, &signum);
                if (errnum != 0) {
                        fprintf(stderr, "sigwait(): %s\n",
                                                strerror(errnum));
                        exit(EXIT_FAILURE);
                }
                assert(signum == SIGUSR1);
                /* Виводить повідомлення. */
                printf("Нащадок\n");
                /* Завершує роботу. */
                exit(EXIT_SUCCESS);
        }
        /* Це код батька */
        /* Виводить повідомлення. */
        printf("Батько\n");
        /* Передає нащадку сигнал SIGUSR1. */
        if (kill(pid, SIGUSR1) != 0) {
                perror("kill()");
                exit(EXIT_FAILURE);
        }
        /* Призупиняється (інакше нащадок втратить зв'язок із терміналом
           і не зможе вивести повідомлення). */
        pause();
        /* Завершує роботу. */
        exit(EXIT_SUCCESS);
}
